import cnrg.itx.datax.*;

import java.net.*;
import java.io.IOException;

public class NullSource implements Source, Runnable
{
	/**
	 * Interface to start the source.
	 */
	public void start(){
	};
	
	public void run() {
	}
	/**
	 * Interface to stop the source.
	 */
	public void stop(){};
	
	/**
	 * Interface to mute the source.
	 * @param mode true for muting and false for resuming
	 */
	public boolean mute(boolean mode){return true;};
	
	/**
	 * Interface for closing the source.
	 */
	public void close(){
	};
 
   /**
    * Interface to return a collection of properties supported by the device.
    * @exception DataException thrown when the properties in the device are incompatible
    */ 
	public PropertiesCollection getProperties() throws DataException {return null;};

   /**
    * Interface to set the given properties collection into the device. Works under the assumption
    * that the properties collection was generated LOCALLY and is a request for options.
    * @exception DataException thrown when trying to set incompatible properties collections
    */
	public void setProperties(PropertiesCollection pc) throws DataException {};

   /**
    * Interface to set the given properties collection into the device. WOrks under the 
    * assumption that this is the properties collection of the peer.
    */
	public void setPeerProperties(PropertiesCollection pc) throws DataException {};
	/**
	 * @return the Stats object which describes the current state of the object.  
	 */
	public Stats getStatistics() {return null;};
}
